#include <cstdlib>
#include <iostream>
#include <unistd.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "halcyon.h"
using namespace std;

/**
 * This is used in conjunction with everything else in the HD Radio Control project.  It's a simple
 * command line program to turn the DTR line on a serial port to low or high.  This is often needed
 * to help with debugging because the DTR line can be left on by accident.  It takes two arguments:
 *   --device: The name of the device, such as /dev/ttyS0, to work with
 *   --state: on or off to turn the DTR line on or off
 */
int main(const int argc, char* argv[]) {
	bool state;
	int fd, status;
	string dev, req;
	ConfigFile mainConfig;

	mainConfig.parseargs(argc, argv);
	dev = mainConfig.getval("device");
	req = mainConfig.getval("state");
	state = false;
	if (req == "high" || req == "on" || req == "true" || req == "1")
		state = true;

	fd = open(dev.c_str(), O_RDWR | O_NOCTTY);
	fcntl(fd, F_SETFL, 0);

	ioctl(fd, TIOCMGET, &status);
	cout << "Device: " << dev << ", Requested State: " << state << ", Current State: " << !!(status & TIOCM_DTR) << endl;
// 	cout << "Device: " << dev << ", Requested State: " << state << ", Current State: " << endl;
	if (state) {
		status |= TIOCM_DTR;
	} else {
		status &= !TIOCM_DTR;
	}
	ioctl(fd, TIOCMSET, &status);
	ioctl(fd, TIOCMGET, &status);
	cout << "\tConfirmed state: " << !!(status & TIOCM_DTR) << endl;
	close(fd);

	return 0;
}
