package com.hal.gui;

import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class HalTableModel extends DefaultTableModel {
	
	private static final long serialVersionUID = 1L;
	
	String[] columnNames;
	Object[][] data;
	
	JTable jTable = null;
	
	public HalTableModel(String[] columnNames) {
		this.columnNames = columnNames;
		data = new Object[][] {{"X Minus 1", "Episode 1"}, {"The Shadow", "Episode A"}, {"The Saint", "YA Episode"}, {"Jack Benny", "Something funny"}};
	}
	
	/**
	 * Set the table we're working with.  This MUST be set for some methods to actually work,
	 * like deleteSelectedRows();
	 * @param jTable
	 */
	public void setTable(JTable jTable) {
		this.jTable = jTable;
		return;
	}
	
    public String getColumnName(int col) {
        return columnNames[col].toString();
    }
    
    public int getRowCount() { 
    	return data.length; 
    }
    
    public int getColumnCount() {
    	return columnNames.length; 
    }
    
    public String getStringValueAt(int iRow, int iCol) {
    	String sValue = (String) getValueAt(iRow, iCol);
    	return sValue;
    }
    
    public Object getValueAt(int row, int col) {
        return data[row][col];
    }
    
//    public boolean isCellEditable(int row, int col) {
//    	return true; 
//    }
    
    public void setValueAt(Object value, int row, int col) {
        data[row][col] = value;
        fireTableCellUpdated(row, col);
    }
    
    public void addRow(Object[] newRow) {
    	
    	return;
    }
    
    public void insertRows(int iRow, Object[][] newRows) {
    	int x;
    	for (x = 0; x < newRows.length; x++) {
    		insertRow(iRow + x, newRows[x]);
    	}
    	return;
    }
    
    public void removeSelectedRows() {
    	
    	return;
    }
    
    public void removeRows(int[] iRows) {
    	
    	return;
    }
}
