package com.hal.gui;
/**
Author : Hal Vaughan
Company: Threshold Digital, Ltd.
			4221 Wakefield Rd.
			Richmond, VA 23235
			(804)-560-2820
			halblog.com
			hal@halblog.com

Specifics:
	HelpPanel: Actually includes tPanel (It was 2:30 am -- easier to cut and paste
	than to think!).  This creates a panel with a lower etched border and a title
	and loads in the specified html help file into a non-editable JTextEditor panel
	with a scrollbar.
*/

import java.awt.*;
import javax.imageio.*;
import javax.swing.*;
import java.io.*;


public class ImagePanel extends JPanel {

	private static final long serialVersionUID = 1L;
	private Image iTitle;
	private int hSize, vSize;

	public ImagePanel(String sFile, int i1, int i2) {
		hSize = i1;
		vSize = i2;
		Color cWhite = new Color(255, 255, 255);
		try {iTitle = ImageIO.read(new File(sFile));} catch (Exception e) {}
		setBackground(cWhite);
		setMinimumSize(new Dimension(hSize, vSize));
		setMaximumSize(new Dimension(hSize, vSize));
		setPreferredSize(new Dimension(hSize, vSize));
		return;
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		if (iTitle == null) {return;}
		int iWidth = iTitle.getWidth(this);
		int iHeight = iTitle.getHeight(this);
		int horzPos = (hSize - iWidth)/2;
		int vertPos = (vSize - iHeight)/2;
		g.drawImage(iTitle, horzPos, vertPos, null);
		return;
	}
}
