package com.hal.oldtimeradio;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

import com.hal.conf.GeneralConfig;
import com.hal.gui.GUIUtils;
import com.hal.gui.HalProgressMonitor;
import com.hal.gui.HelpWindow;
import com.hal.util.HalFile;
import com.hal.util.IndexHashMap;
import com.hal.util.StringHashMap;

import entagged.audioformats.AudioFile;
import entagged.audioformats.AudioFileIO;
import entagged.audioformats.Tag;

public class TagEditor implements ActionListener, ListSelectionListener, DocumentListener {

	private JFrame jFrame = null;  //  @jve:decl-index=0:visual-constraint="479,33"
	private JFrame jfCopy = null;  //  @jve:decl-index=0:visual-constraint="14,35"
	private JPanel jContentPane = null;
	private JPanel jContentPane1 = null;
	private JScrollPane jspTitles = null;
	private JScrollPane jScrollPane = null;
	private JLabel jLabel = null;
	private JLabel jLabel1 = null;
	private JLabel jLabel2 = null;
	private JLabel jLabel3 = null;
	private JLabel jLabel4 = null;
	private JLabel jlCopyFromTo = null;
	private JButton jbHelp = null;
	private JButton jbClose = null;
	private JButton jbCopyTo = null;
	private JButton jbCopyFrom = null;
	private JButton jbSave = null;
	private JButton jbCopy = null;
	private JButton jbCancel = null;
	private JList jlTitles = null;
	private JList jlCopyTitles = null;
	private JComboBox jcbTagName = null;
	private JComboBox jcbValueFields = null;
	private JTextField jtfTagValue = null;
	
	boolean isVisible = false, firstOpen = true, copyFrom = true, useMonitor = false, firstHelp = true;
	int lastTitle = -1;
	
	JFrame parentFrame;
	GeneralConfig myConfig;
	ShowData allShows;
	EpisodeData dlEps;
	String defaultTagFile = "0000-otrDefault", helpFile = "0000-OTRTagHelp.html";  //  @jve:decl-index=0:
	String[] tagNames = new String[0], showNames = new String[0];
	StringHashMap tagData, dlTags;
	public StringHashMap tagVariables = null;
	public IndexHashMap dlCount;
	String fieldValFile = "0000-otrFields.val", lastShowTitle = "", humanShowTitle = "";
	TitleFilter dlTitles = null;
	TitleFilterControl titleControl;
	GUIUtils guiUtils;
	HalProgressMonitor pMonitor;
	HelpWindow helpWindow;
	private JPanel jPanel = null;
	private JPanel jPanel1 = null;
	private JPanel jPanel2 = null;
	private JPanel jPanel3 = null;
	private JPanel jPanel4 = null;
	private JLabel jLabel5 = null;

	/**
	 * This method initializes everything.  Nothing special.
	 */
	public TagEditor(GeneralConfig programConfig) {
		myConfig = programConfig;
		allShows = (ShowData) myConfig.getObject("allshows");
		dlEps = new EpisodeData(myConfig, allShows);
		tagData = new StringHashMap();
		guiUtils = new GUIUtils(myConfig);
		myConfig.putObject("tageditor", this);
		guiSetup();
		jlTitles.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		reload();
		jlTitles.removeListSelectionListener(this);
		jlTitles.setSelectedIndex(0);
		jlTitles.addListSelectionListener(this);
		String[] fieldVals = loadValueFields();
		dlCount = new IndexHashMap();
		setValueFields(fieldVals);
		if (myConfig.hasObject("titlefiltercontrol"))
			titleControl = new TitleFilterControl(myConfig);
		else
			titleControl = null;
		pMonitor = new HalProgressMonitor(jFrame, "Copying Tag Settings...");
		helpWindow = new HelpWindow(600, 400, "Help for tags.", "Old Time Radio Show Downloader Tag Help");
		helpFile = myConfig.get("OTRDirectory") + File.separator + helpFile;
		helpWindow.setFile(helpFile);
	}
	
	/**
	 * Reinitialize everything if we're starting or if the show list changes.
	 */
	public void reload() {
		loadShows();
		setTags();
		return;
	}
	
	/**
	 * Load the names of the fields that can be inserted into the tag value
	 */
	public String[] loadValueFields() {
		String fullPath, fileData;
		String[] fieldNames;
		fullPath = myConfig.get("OTRDirectory") + File.separator + fieldValFile;
		fileData = HalFile.fileToString(fullPath);
		fieldNames = fileData.split("\n");
		return fieldNames;
	}
	
	/**
	 * Set the value fields in the combo box.  This gives the user the choice of fields
	 * that can be inserted into the tag values
	 * @param newFields
	 */
	public void setValueFields(String[] newFields) {
		int x;
		jcbValueFields.removeActionListener(this);
		jcbValueFields.removeAllItems();
		for (x = 0; x < newFields.length; x++) {
			if (newFields[x].startsWith("#") || newFields[x].equals(""))
				continue;
			jcbValueFields.addItem("<" + newFields[x] + ">");
		}
		jcbValueFields.addActionListener(this);
		return;
	}
	
	/**
	 * Load in the names of all the shows to the selection list.
	 */
	public void loadShows() {
		int x, iPoint;
		jlTitles.removeListSelectionListener(this);
		iPoint = jlTitles.getSelectedIndex();
		if (iPoint < 0)
			iPoint = 0;
		String[] tempTitles = allShows.listSortedTitles();
		showNames = new String[tempTitles.length + 1];
		showNames[0] = "<html><font color=\"red\">Default Tags</font></html>";
		for (x = 0; x < tempTitles.length; x++) {
			showNames[x + 1] = tempTitles[x];
		}
		jlTitles.setListData(showNames);
		jlCopyTitles.setListData(showNames);
		if (iPoint >= tempTitles.length)
			iPoint = tempTitles.length - 1;
		jlTitles.setSelectedIndex(iPoint);
		jlTitles.addListSelectionListener(this);
		return;
	}
	
	/**
	 * Set the tags as appropriate by creating the list of tag names and setting
	 * the proper value.  This also includes calling on methods to get the file name
	 * to load tags from and getting them from disk.
	 */
	public void setTags() {
		String showName = getShowFile();
		tagData = loadTags(showName);
		setTagValues();
		return;
	}
	
	/**
	 * Part of setting the tags.  This just lets us set the values without loading new ones in.
	 */
	public void setTagValues() {
		int x, iPoint;
		iPoint = jcbTagName.getSelectedIndex();
		tagNames = tagData.keySet();
		jcbTagName.removeAllItems();
		for (x = 0; x < tagNames.length; x++) {
			jcbTagName.addItem(tagNames[x]);
		}
		if (iPoint >= tagNames.length) {
			iPoint = tagNames.length - 1;
		}
		if (iPoint < 0) {
			iPoint = 0;
		}
		jcbTagName.setSelectedIndex(iPoint);
		setTagValue();
		return;
	}
	
	/**
	 * Load the tags for a particular show (or the default file) into a hashmap.  This does
	 * not set tags so it can be used by the shell or control panel to load tags for work
	 * when downloading or to load tags when copying them.
	 * @param showFile show name (or default) for the tags we're going to load
	 * @return key/value hashmap of file tags
	 */
	public StringHashMap loadTags(String showFile) {
		String fileName;
		StringHashMap newTags = new StringHashMap();
		if (showFile == null || showFile.equalsIgnoreCase("default") || showFile.equalsIgnoreCase("default tags")) {
			showFile = defaultTagFile;
		}
		fileName = getFilePath(showFile);
		File oFile = new File(fileName);
		if (oFile.exists()) {
			newTags = HalFile.fileToHash(fileName);
		} else {
			fileName = getFilePath(defaultTagFile);
			oFile = new File(fileName);
			if (oFile.exists()) {
//				System.out.println("Loading Default file: " + fileName);
				newTags = HalFile.fileToHash(fileName);
			} else {
				System.out.println("Setting default values");
				newTags.put("Artist", "Old Time Radio");
				newTags.put("Album", "<showtitle>");
				newTags.put("Title", "<episodetitle>");
				newTags.put("Genre", "Old Time Radio");
				newTags.put("Track", "<fileorder>");
				newTags.put("Year", "");
				newTags.put("Comment", "Old time radio show downloaded from http://archive.org");
			}
			
		}
		return newTags;
	}
	
	/**
	 * Save the current set of tags for this show (or for default).
	 */
	public void saveTags() {
		int x;
		String showName = defaultTagFile, fileName;
		String[] tagKeys;
		String outData = "";
		showName = getShowFile();
		fileName = getFilePath(showName);
//		System.out.println("Saving tags to file: " + fileName);
		tagKeys = tagData.keySet();
		for (x = 0; x < tagKeys.length; x++) {
			outData = outData + tagKeys[x] + "=" + tagData.get(tagKeys[x]);
			if (x < tagKeys.length - 1) {
				outData = outData + "\n";
			}
		}
		HalFile.stringToFile(fileName, outData);
		return;
	}
	
	/**
	 * Get the default show file name for the currently selected show.
	 * @return file name
	 */
	private String getShowFile() {
		String showFile = "";
		if (jlTitles.getSelectedIndex() == 0) {
			showFile = defaultTagFile;
		} else {
			showFile = (String) jlTitles.getSelectedValue();
			showFile = allShows.getDirectory(showFile);
		}
		return showFile;
	}
	
	/**
	 * Make the file path for the show we're working with.
	 * @param fileName either Default for the default tag file or the name of the default file/directory
	 * name for the current show
	 * @return the full file path with a .tag added on to the end
	 */
	private String getFilePath(String fileName) {
		String fullPath = "";
		fullPath = myConfig.get("OTRDirectory") + File.separator + fileName + ".tag";
		return fullPath;
	}
	
	/**
	 * Set the value in the text field to the value that matches the
	 * particular tag selected.
	 */
	private void setTagValue() {
		jtfTagValue.getDocument().removeDocumentListener(this);
		String tagName = (String) jcbTagName.getSelectedItem();
		String tagValue = tagData.get(tagName);
		jtfTagValue.setText(tagValue);
		jtfTagValue.getDocument().addDocumentListener(this);
		return;
	}
	
	/**
	 * When a field name is selected, we insert it into the value for the tag.  This allows
	 * us to insert dynamic variables, such as the download date or the show title, into a tag.
	 */
	private void insertTextInValue() {
		int iPoint = jtfTagValue.getCaretPosition();
		String sText = jtfTagValue.getText();
		String sField = (String) jcbValueFields.getSelectedItem();
		sText = sText.substring(0, iPoint) + sField + sText.substring(iPoint);
		jtfTagValue.setText(sText);
		jtfTagValue.setCaretPosition(iPoint + sField.length());
		jtfTagValue.grabFocus();
		return;
	}
	
	/**
	 * Open the window to select where tags are copied to or from.  Don't copy, just open window
	 * and make selection of a show (or shows) possible
	 * @param copyFrom true if we're copying FROM files.
	 */
	private void setupCopy() {
		String fromLabel = "Copy Tags From Another Show...";
		String toLabel = "Copy Tags To Other Show(s)...";
		if (copyFrom) {
			if (jlTitles.getSelectedIndex() == 0) {
				guiUtils.setParentFrame(jFrame);
				guiUtils.setParentFrame(jFrame);
				guiUtils.showInfoDialog("The default tag values are selected.\nThe default settings cannot be copied over.");
				return;
			}
			jlCopyFromTo.setText(fromLabel);
			jlCopyTitles.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			int[] iCheck = jlCopyTitles.getSelectedIndices();
			if (iCheck.length > 1) {
				jlCopyTitles.clearSelection();
			}
		} else {
			jlCopyFromTo.setText(toLabel);
			jlCopyTitles.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		}
		GUIUtils.centerWindowOnWindow(jFrame, jfCopy);
		setActive(false);
		setCopyActive(true);
		this.jfCopy.setVisible(true);
		return;
	}
	
	/**
	 * Copy the tags from one show to another (or to more than one show).  Use info set up by setupCopy().
	 */
	private void copyTags() {
		new Thread(new Runnable() {
			public void run() {
				useMonitor = false;
				int x;
				int[] iDest;
				String tagSource = "", sourceFile, destFile;
				setCopyActive(false);
				if (copyFrom) {
					tagSource = (String) jlCopyTitles.getSelectedValue();
					tagSource = allShows.getDirectory(tagSource);
					iDest = jlTitles.getSelectedIndices();
					sourceFile = getFilePath(tagSource);
				} else {
//					System.out.println("Getting show files for source and dest.");
					tagSource = getShowFile();
//					System.out.println("\tSource: " + tagSource);
					iDest = jlCopyTitles.getSelectedIndices();
					sourceFile = getFilePath(tagSource);
					File oFile = new File(sourceFile);
					if (!oFile.exists())
						saveTags();
				}
//				tagSource = allShows.getDirectory(tagSource);
//				System.out.println("\t\tSource: " + tagSource);
//				if (iDest.length > 3) {
//					useMonitor = true;
//					pMonitor.activate();
//					pMonitor.setTaskLength(0, iDest.length);
//				}
				for (x = 0; x < iDest.length; x++) {
					if (iDest[x] != 0) {
						destFile = showNames[iDest[x]];
						destFile = allShows.getDirectory(destFile);
						destFile = getFilePath(destFile);
						System.out.println("Copying file: " + sourceFile + ", To: " + destFile);
						if (sourceFile.equals(destFile)) {
							continue;
						}
						File oSource = new File(sourceFile);
						if (!oSource.exists()) {
							String defaultFile = getFilePath(defaultTagFile);
							HalFile.copy(defaultFile, sourceFile);
							System.out.println("\tForced to use default file: " + defaultFile);
						}
						HalFile.copy(sourceFile, destFile);
					} else {
						guiUtils.setParentFrame(jFrame);
						guiUtils.showInfoDialog("The default tag settings were selected.\nCannot copy other tags to default tags.");
					}
//					if (useMonitor) {
//						pMonitor.updateProgressBar(x + 1);
//						if (pMonitor.isCancelled)
//							break;
//					}
				}
//				if (useMonitor)
//					pMonitor.deactivate();
				setActive(true);
				jfCopy.setVisible(false);
			}
		}).start();
		return;
	}

	/**
	 * Set all the components in this window and the copy window to active or inactive.
	 * @param isActive true if components are to be useable
	 */
	public void setActive(boolean isActive) {
		jlTitles.setEnabled(isActive);
		jbHelp.setEnabled(isActive);
		jbClose.setEnabled(isActive);
		jbCopyTo.setEnabled(isActive);
		jbCopyFrom.setEnabled(isActive);
		jbSave.setEnabled(isActive);
		jcbTagName.setEnabled(isActive);
		jcbValueFields.setEnabled(isActive);
		jtfTagValue.setEnabled(isActive);
		setCopyActive(isActive);
		return;
	}
	
	/**
	 * Set just the components in the copy settings window to active or inactive.
	 * @param isActive true if components are t obe useable
	 */
	public void setCopyActive(boolean isActive) {
		jlCopyTitles.setEnabled(isActive);
		jbCopy.setEnabled(isActive);
		jbCancel.setEnabled(isActive);
		return;
	}

	/**
	 * The tags for mp3/ogg/flac files are passed in key/value pairs in
	 * a StringHashMap.  We set them using the Entagged library.
	 * @param showTitle the show title the episode is part of
	 * @param epFile the name of the file the episode will be stored in (only the filename, not the path)
	 * @param fileName full pathname of file to set the tags in
	 * @param webURL the url location of hte episode file on the web
	 */
	public boolean setFileTags(String showTitle, String epFile, String fileName, String webURL) {
//		boolean bSuccess = true;
		int x;
		StringHashMap allTags = getTags(showTitle, epFile);
		String tagName, tagValue;
		String[] allKeys = allTags.keySet();
//		System.out.println("Show: " + showTitle + ", Episode file: " + epFile);
//		for (x = 0; x < allKeys.length; x++) {
//			System.out.println("\tTag: " + allKeys[x] + ", Value: " + allTags.get(allKeys[x]));
//		} if (true) return;
		File rawFile = new File(fileName);
		AudioFile audFile = null;
		AudioFileIO afIO = new AudioFileIO();
		try {
			audFile = afIO.readFile(rawFile);
		} catch (Exception e) {
			System.out.println("Exception reading in file to tag: " + e.toString());
			return false;
		}
		Tag tagInfo = audFile.getTag();
//		System.out.println("Tagging file: " + rawFile);
		for (x = 0; x < allKeys.length; x++) {
			tagName = allKeys[x];
			tagValue = allTags.get(tagName);
//			System.out.println("\tTag name: " + tagName + ", Tag value: " + tagValue);
			if (tagName.equalsIgnoreCase("Artist")) {
				tagInfo.setArtist(tagValue);
			} else if (tagName.equalsIgnoreCase("Album")) {
				tagInfo.setAlbum(tagValue);
			} else if (tagName.equalsIgnoreCase("Track")) {
				tagInfo.setTrack(tagValue);
			} else if (tagName.equalsIgnoreCase("Title")) {
				tagInfo.setTitle(tagValue);
			} else if (tagName.equalsIgnoreCase("Genre")) {
				tagInfo.setGenre(tagValue);
			} else if (tagName.equalsIgnoreCase("Year")) {
				tagInfo.setYear(tagValue);
			} else if (tagName.equalsIgnoreCase("Comment")) {
				tagInfo.setComment(tagValue);
			}
		}
		try {
			audFile.commit();
			AudioFileIO.write(audFile);
		} catch (Exception e) {System.out.println("Error writing file: " + e.toString());}
		return true;
	}
	
	/**
	 * Set all the tag values for a specified episode.
	 * @param showTitle title of the show or series
	 * @param epFile the episode file we are downloading and changing info on.
	 */
	public StringHashMap getTags(String showTitle, String epFile) {
		int x, y;
		String showDir = allShows.getDirectory(showTitle), tagValue, varName, varValue, titleFile;
		String[] tagNames, varNames;
		String[] calMonths = new String[] {"January", "February", "March", "April", "May",
				"June", "July", "August", "September", "October", "Novemeber", "December"};
		StringHashMap epTags = new StringHashMap(), tagVars = new StringHashMap();
		GregorianCalendar cDate = new GregorianCalendar();
		Pattern pRegex;
		Matcher mRegex;
//		System.out.println("Show title: " + showTitle + ", Last Show Title: " + lastShowTitle);
		if (!showTitle.equals(lastShowTitle)) {
			dlEps.reset();
			dlEps.loadEpisodes(showTitle);
			dlTags = loadTags(showDir);
			titleFile = myConfig.get("OTRDirectory") + File.separator + showDir + ".ttl";
//			System.out.println("Title file: " + titleFile);
			dlTitles = new TitleFilter(titleFile);
			lastShowTitle = showTitle;
			humanShowTitle = dlTags.get("Album");
			if (humanShowTitle.contains("<showtitle>")) {
				pRegex = Pattern.compile("<showtitle>");
				mRegex = pRegex.matcher(humanShowTitle);
				humanShowTitle = mRegex.replaceAll(showTitle);
				
			}
		}
		dlCount.inc(humanShowTitle);
		
		tagValue = humanShowTitle;
		tagVars.put("showtitle", tagValue);
//		System.out.println("Show title tag (<showtitle>): " + humanShowTitle + ", 'Official human title: " + showTitle);
		
		tagValue = allShows.getDirectory(showTitle);
		tagVars.put("defaultshowtitle", tagValue);
		
		tagValue = titleFilter(epFile);
		tagVars.put("episodetitle", tagValue);
		
		tagValue = dlEps.getFileOrder(epFile);
		tagVars.put("fileorder", tagValue);
		
		tagValue = String.valueOf(dlCount.get(humanShowTitle));
		tagVars.put("downloadorder", tagValue);
		
		tagValue = dlEps.getURL(epFile);
		tagVars.put("url", tagValue);
		
		tagValue = String.valueOf(cDate.get(Calendar.YEAR));
		tagVars.put("year", tagValue);
		
		tagValue = String.valueOf(cDate.get(Calendar.YEAR));
		tagValue = tagValue.substring(2);
		tagVars.put("yy", tagValue);
		
		tagValue = String.valueOf(cDate.get(Calendar.YEAR));
		tagValue = tagValue.substring(2);
		tagVars.put("mm", tagValue);
		
		tagValue = calMonths[cDate.get(Calendar.MONTH)];
		tagVars.put("month", tagValue);
		
		tagValue = "00" + String.valueOf(cDate.get(Calendar.DATE));
		tagValue = tagValue.substring(tagValue.length() - 2);
		tagVars.put("dd", tagValue);
		
		tagNames = dlTags.keySet();
		varNames = tagVars.keySet();
		Arrays.sort(tagNames);
		Arrays.sort(varNames);
//		System.out.println("Editing tags.");
		for (x = 0; x < tagNames.length; x++) {
			tagValue = dlTags.get(tagNames[x]);
//			System.out.println("\tTag Name: " + tagNames[x] + ", Value: " + tagValue);
			for (y = 0; y < varNames.length; y++) {
				varName = varNames[y];
				varValue = tagVars.get(varName);
				varName =  "<" + varName + ">";
//				System.out.println("\t\tPatern: " + varName + ", Target String: " + tagValue + ", Replacement Value: " + varValue);
				pRegex = Pattern.compile(varName);
				mRegex = pRegex.matcher(tagValue);
				tagValue = mRegex.replaceAll(varValue);
//				System.out.println("\t\t\tNew Value: " + tagValue);
			}
			epTags.put(tagNames[x], tagValue);
		}
		return epTags;
	}
	
	/**
	 * To be replaced with calls to actual title editor.
	 * @param sTitle
	 * @return fitlered title name
	 */
	public String titleFilter(String sTitle) {
		String newTitle = sTitle;
		if (dlTitles != null)
			newTitle = dlTitles.filterTitle(sTitle);
//		System.out.println("Finished title: " + newTitle);
		return newTitle;
	}
	
	/**
	 * Make us visible.  Center over main window if this is the first time we're visible.
	 * @param isVisible true to make visible
	 */
	public void setVisible(boolean isVisible) {
		this.isVisible = isVisible;
		if (firstOpen && parentFrame != null) {
			GUIUtils.centerWindowOnWindow(parentFrame, jFrame);
			firstOpen = false;
		}
		jFrame.setVisible(isVisible);
		return;
	}
	
	/**
	 * Dispense all the Swing events to the routine that does the needed work.
	 */
	public void actionPerformed(ActionEvent aEvent) {
		Object controlSource = aEvent.getSource();
		if (controlSource == jbCopyFrom) {
			copyFrom = true;
			setupCopy();
			return;
		} else if (controlSource == jbCopyTo) {
			copyFrom = false;
			setupCopy();
			return;
		} else if (controlSource == this.jbCopy) {
			copyTags();
			return;
		} else if (controlSource == this.jbCancel) {
			jfCopy.setVisible(false);
			setActive(true);
			return;
		} else if (controlSource == jbSave) {
			saveTags();
			guiUtils.setParentFrame(jFrame);
			guiUtils.showInfoDialog("Tags saved.");
			return;
		} else if (controlSource == jcbTagName) {
			setTagValue();
			return;
		} else if (controlSource == jcbValueFields) {
			insertTextInValue();
			return;
		} else if (controlSource == jbHelp) {
			if (firstHelp)
				helpWindow.centerOnWindow(jFrame);
			firstHelp = false;
			helpWindow.setVisible(true);
			return;
		} else if (controlSource == jbClose) {
			setVisible(false);
			return;
		}
		return;
	}
	
	/**
	 * Document changed listener method to detect changes in text field.  If the text field
	 * changes, then the value of the tag has changed and we have to update it.
	 */
	public void changedUpdate(DocumentEvent dEvent) {
		Document sourceDoc = dEvent.getDocument();
		String sKey = (String) jcbTagName.getSelectedItem();
		if (sourceDoc != jtfTagValue.getDocument() || sKey == null) {
			return;
		}
		tagData.put(sKey, jtfTagValue.getText());
		return;
	}
	
	/**
	 * For document listener requirements.  Just calls changedUpdate() so the work is done there.
	 */
	public void insertUpdate(DocumentEvent dEvent) {
		changedUpdate(dEvent);
		return;
	}
	
	/**
	 * For document listener requirements.  Just calls changedUpdate() so the work is done there.
	 */
	public void removeUpdate(DocumentEvent dEvent) {
		changedUpdate(dEvent);
		return;
	}
	
	/**
	 * Needed to be a ListSelectionListener, changes tags when the show title changes.
	 */
	public void valueChanged(ListSelectionEvent lsEvent) {
		int iSel = jlTitles.getSelectedIndex();
		if (iSel == lastTitle || iSel == -1 || jlTitles.getSelectedValue() == null) return;
		setTags();
		lastTitle = iSel;
		return;
	}
	
	/**
	 * The ugly part of the GUI setup stuff taht the VE didn't create.  Down here, away 
	 * from everythign else so it's out of the way and with the non-human produced part of the code.
	 */
	private void guiSetup() {
		getJFrame();
		getJfCopy();
		jlTitles.addListSelectionListener(this);
		jbClose.addActionListener(this);
		jbCopyFrom.addActionListener(this);
		jbCopyTo.addActionListener(this);
		jbCopy.addActionListener(this);
		jbCancel.addActionListener(this);
		jbSave.addActionListener(this);
		jcbTagName.addActionListener(this);
		jtfTagValue.addActionListener(this);
		jtfTagValue.getDocument().addDocumentListener(this);
		jcbValueFields.addActionListener(this);
		jbHelp.addActionListener(this);
		jbClose.addActionListener(this);
		guiUtils.setParentFrame(jFrame);
		return;
	}

//	=============================================================================
//	Beyond here, there be dragons
//	=============================================================================
		
	/**
	 * This method initializes jFrame	
	 * 	
	 * @return javax.swing.JFrame	
	 */
	private JFrame getJFrame() {
		if (jFrame == null) {
			jFrame = new JFrame();
			jFrame.setSize(new Dimension(452, 464));
			jFrame.setTitle("Old Time Radio Show Downloader: Tag Editor");
			jFrame.setContentPane(getJContentPane());
		}
		return jFrame;
	}

	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
			gridBagConstraints8.insets = new Insets(6, 12, 5, 11);
			gridBagConstraints8.gridy = 7;
			gridBagConstraints8.ipadx = 260;
			gridBagConstraints8.ipady = 1;
			gridBagConstraints8.gridx = 0;
			GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
			gridBagConstraints7.insets = new Insets(6, 12, 12, 11);
			gridBagConstraints7.gridy = 8;
			gridBagConstraints7.ipadx = 173;
			gridBagConstraints7.gridx = 0;
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.insets = new Insets(6, 12, 5, 11);
			gridBagConstraints6.gridy = 6;
			gridBagConstraints6.ipadx = 349;
			gridBagConstraints6.ipady = 6;
			gridBagConstraints6.gridx = 0;
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.insets = new Insets(6, 12, 5, 11);
			gridBagConstraints5.gridy = 4;
			gridBagConstraints5.ipadx = 320;
			gridBagConstraints5.ipady = 1;
			gridBagConstraints5.gridx = 0;
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.insets = new Insets(6, 12, 11, 11);
			gridBagConstraints4.gridy = 2;
			gridBagConstraints4.ipadx = 140;
			gridBagConstraints4.gridx = 0;
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.insets = new Insets(12, 12, 5, 11);
			gridBagConstraints3.gridy = 3;
			gridBagConstraints3.ipadx = 317;
			gridBagConstraints3.ipady = 10;
			gridBagConstraints3.gridx = 0;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.insets = new Insets(6, 12, 5, 11);
			gridBagConstraints2.gridy = 5;
			gridBagConstraints2.ipadx = 55;
			gridBagConstraints2.ipady = 10;
			gridBagConstraints2.gridx = 0;
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 1;
			gridBagConstraints1.ipadx = 162;
			gridBagConstraints1.ipady = -22;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.weighty = 1.0;
			gridBagConstraints1.insets = new Insets(6, 12, 5, 11);
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.insets = new Insets(12, 120, 5, 119);
			gridBagConstraints.gridy = 0;
			gridBagConstraints.ipadx = 36;
			gridBagConstraints.ipady = 10;
			gridBagConstraints.gridx = 0;
			jLabel2 = new JLabel();
			jLabel2.setText("Tag Information:");
			jLabel4 = new JLabel();
			jLabel4.setText("Use text or fields selected from below to set the tag value:");
			jLabel3 = new JLabel();
			jLabel3.setText("Tag Value: ");
			jLabel1 = new JLabel();
			jLabel1.setText("Edit Tag Settings for Show:");
			jLabel = new JLabel();
			jLabel.setText("Tag Name: ");
			jContentPane = new JPanel();
			jContentPane.setLayout(new GridBagLayout());
			jContentPane.add(jLabel1, gridBagConstraints);
			jContentPane.add(getJspShowTitles(), gridBagConstraints1);
			jContentPane.add(jLabel4, gridBagConstraints2);
			jContentPane.add(jLabel2, gridBagConstraints3);
			jContentPane.add(getJPanel(), gridBagConstraints4);
			jContentPane.add(getJPanel1(), gridBagConstraints5);
			jContentPane.add(getJPanel2(), gridBagConstraints6);
			jContentPane.add(getJPanel3(), gridBagConstraints7);
			jContentPane.add(getJPanel4(), gridBagConstraints8);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jcbTagName	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJcbTagName() {
		if (jcbTagName == null) {
			jcbTagName = new JComboBox();
		}
		return jcbTagName;
	}

	/**
	 * This method initializes jspShowTitles	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJspShowTitles() {
		if (jspTitles == null) {
			jspTitles = new JScrollPane();
			jspTitles.setViewportView(getJlTitles());
		}
		return jspTitles;
	}

	/**
	 * This method initializes jbCopyFrom	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbCopyFrom() {
		if (jbCopyFrom == null) {
			jbCopyFrom = new JButton();
			jbCopyFrom.setText("Copy From Other");
		}
		return jbCopyFrom;
	}

	/**
	 * This method initializes jbSave	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbSave() {
		if (jbSave == null) {
			jbSave = new JButton();
			jbSave.setText("Save Settings");
		}
		return jbSave;
	}

	/**
	 * This method initializes jtfTagValue	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJtfTagValue() {
		if (jtfTagValue == null) {
			jtfTagValue = new JTextField();
		}
		return jtfTagValue;
	}

	/**
	 * This method initializes jcbValueFields	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJcbValueFields() {
		if (jcbValueFields == null) {
			jcbValueFields = new JComboBox();
		}
		return jcbValueFields;
	}

	/**
	 * This method initializes jbHelp	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbHelp() {
		if (jbHelp == null) {
			jbHelp = new JButton();
			jbHelp.setText("Help");
		}
		return jbHelp;
	}

	/**
	 * This method initializes jbClose	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbClose() {
		if (jbClose == null) {
			jbClose = new JButton();
			jbClose.setText("Close");
		}
		return jbClose;
	}

	/**
	 * This method initializes jbCopyTo	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbCopyTo() {
		if (jbCopyTo == null) {
			jbCopyTo = new JButton();
			jbCopyTo.setText("Copy To Other(s)");
		}
		return jbCopyTo;
	}

	/**
	 * This method initializes jlTitles	
	 * 	
	 * @return javax.swing.JList	
	 */
	private JList getJlTitles() {
		if (jlTitles == null) {
			jlTitles = new JList();
		}
		return jlTitles;
	}

	/**
	 * This method initializes jfCopy	
	 * 	
	 * @return javax.swing.JFrame	
	 */
	private JFrame getJfCopy() {
		if (jfCopy == null) {
			jfCopy = new JFrame();
			jfCopy.setSize(new Dimension(454, 236));
			jfCopy.setTitle("Copy Settings");
			jfCopy.setContentPane(getJContentPane1());
		}
		return jfCopy;
	}

	/**
	 * This method initializes jContentPane1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane1() {
		if (jContentPane1 == null) {
			jlCopyFromTo = new JLabel();
			jlCopyFromTo.setBounds(new Rectangle(96, 12, 253, 25));
			jlCopyFromTo.setText("Copy Settings From a Show:");
			jContentPane1 = new JPanel();
			jContentPane1.setLayout(null);
			jContentPane1.add(jlCopyFromTo, null);
			jContentPane1.add(getJScrollPane(), null);
			jContentPane1.add(getJbCopy(), null);
			jContentPane1.add(getJbCancel(), null);
		}
		return jContentPane1;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setBounds(new Rectangle(12, 48, 421, 109));
			jScrollPane.setViewportView(getJlCopyTitles());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jbCopy	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbCopy() {
		if (jbCopy == null) {
			jbCopy = new JButton();
			jbCopy.setBounds(new Rectangle(96, 168, 121, 25));
			jbCopy.setText("Copy");
		}
		return jbCopy;
	}

	/**
	 * This method initializes jbCancel	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbCancel() {
		if (jbCancel == null) {
			jbCancel = new JButton();
			jbCancel.setBounds(new Rectangle(228, 168, 121, 25));
			jbCancel.setText("Cancel");
		}
		return jbCancel;
	}

	/**
	 * This method initializes jlCopyTitles	
	 * 	
	 * @return javax.swing.JList	
	 */
	private JList getJlCopyTitles() {
		if (jlCopyTitles == null) {
			jlCopyTitles = new JList();
		}
		return jlCopyTitles;
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			jPanel = new JPanel();
			jPanel.setLayout(new BoxLayout(getJPanel(), BoxLayout.X_AXIS));
			jPanel.add(getJbCopyFrom(), null);
			jPanel.add(Box.createHorizontalGlue());
			jPanel.add(getJbCopyTo(), null);
		}
		return jPanel;
	}

	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel1() {
		if (jPanel1 == null) {
			jPanel1 = new JPanel();
			jPanel1.setLayout(new BoxLayout(getJPanel1(), BoxLayout.X_AXIS));
			jPanel1.add(jLabel, null);
			jPanel1.add(getJcbTagName(), null);
		}
		return jPanel1;
	}

	/**
	 * This method initializes jPanel2	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel2() {
		if (jPanel2 == null) {
			jPanel2 = new JPanel();
			jPanel2.setLayout(new BoxLayout(getJPanel2(), BoxLayout.X_AXIS));
			jPanel2.add(jLabel3, null);
			jPanel2.add(getJtfTagValue(), null);
		}
		return jPanel2;
	}

	/**
	 * This method initializes jPanel3	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel3() {
		if (jPanel3 == null) {
			jPanel3 = new JPanel();
			jPanel3.setLayout(new BoxLayout(getJPanel3(), BoxLayout.X_AXIS));
			jPanel3.add(getJbSave(), null);
			jPanel3.add(Box.createHorizontalGlue());
			jPanel3.add(getJbHelp(), null);
			jPanel3.add(Box.createHorizontalGlue());
			jPanel3.add(getJbClose(), null);
		}
		return jPanel3;
	}

	/**
	 * This method initializes jPanel4	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel4() {
		if (jPanel4 == null) {
			jPanel4 = new JPanel();
			jPanel4.setLayout(new BoxLayout(getJPanel4(), BoxLayout.X_AXIS));
			jPanel4.add(getJLabel5(), null);
			jPanel4.add(getJcbValueFields(), null);
		}
		return jPanel4;
	}

	/**
	 * This method initializes jLabel5	
	 * 	
	 * @return javax.swing.JLabel	
	 */
	private JLabel getJLabel5() {
		if (jLabel5 == null) {
			jLabel5 = new JLabel();
			jLabel5.setText("Special Field Values: ");
		}
		return jLabel5;
	}

}  //  @jve:decl-index=0:visual-constraint="280,8"
