package com.hal.oldtimeradio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.hal.conf.GeneralConfig;
import com.hal.gui.GUIUtils;
import com.hal.gui.HalProgressMonitor;
import com.hal.gui.HelpWindow;
import com.hal.util.HalFile;
import java.awt.Rectangle;
import java.awt.GridLayout;
import java.awt.GridBagConstraints;

public class TitleFilterControl implements ActionListener, ChangeListener, ListSelectionListener {
/*
 * Check box:
 * 	Replace _ with " "
 * 	Replace [a-z][A-Z] with [a-z] [A-Z]
 *  Remove file extension
 * 
 * Trim:
 * 	non-alpha at start
 *  up through text
 *  up until text
 *  whitespace
 *  date (in different lengths)
 *  specific text
 */	
	

	private JFrame jFrame = null;  //  @jve:decl-index=0:visual-constraint="424,16"
	private JFrame jfCopy = null;  //  @jve:decl-index=0:visual-constraint="10,55"
	private JPanel jContentPane = null;
	private JPanel jpCopyContent = null;
	private JPanel jPanel = null;
	private JPanel jpCopyButtons = null;
	private JPanel jpTitleButtons = null;
	private JPanel jpRuleButtons1 = null;
	private JPanel jpRulesButtons2 = null;
	private JPanel jpCenter = null;
	private JPanel jPanel1 = null;
	private JPanel jPanel2 = null;
	private JPanel jPanel3 = null;
	private JPanel jPanel4 = null;
	private JPanel jPanel5 = null;
	private JPanel jPanel6 = null;
	private JPanel jPanel7 = null;
	private JPanel jPanel8 = null;
	private JPanel jPanel9 = null;
	private JPanel jPanel10 = null;
	private JScrollPane jspShows = null;
	private JScrollPane jspRules = null;
	private JScrollPane jspEpisodes = null;
	private JScrollPane jspCopy = null;
	private JLabel jLabel = null;
	private JLabel jLabel1 = null;
	private JLabel jLabel2 = null;
	private JLabel jLabel3 = null;
	private JLabel jlCopyFromTo = null;
	private JButton jbClose = null;
	private JButton jbHelp = null;
	private JButton jbSave = null;
	private JButton jbCopyFrom = null;
	private JButton jbCopyTo = null;
	private JButton jbMoveUp = null;
	private JButton jbMoveDown = null;
	private JButton jbDelete = null;
	private JButton jbAdd = null;
	private JButton jbCopy = null;
	private JButton jbCancel = null;
	private JButton jbResetEpisodes = null;
	private JButton jbUpdateEpisodes = null;
	private JCheckBox jcbUnderlines = null;
	private JCheckBox jcbCaps = null;
	private JCheckBox jcbExtension = null;
	private JCheckBox jcbSpaces = null;
	private JComboBox jcbRules = null;
	private JList jlShows = null;
	private JList jlEpisodes = null;
	private JList jlRules = null;
	private JList jlCopyTitles = null;

	boolean isVisible = false, firstOpen = true, copyFrom = false, useMonitor = false, firstHelp = true;

	int lastEditShow = -1;
	String lastWorkShow = "", defaultNoEps = "No available episode files for this show.", helpFile = "0000-OTRTitleHelp.html";
	String defaultFilterFile = "000-otrDefault";  //  @jve:decl-index=0:
	String[] filterDesc = new String[0], showNames;
	LinkedList qRule;
	
	JFrame parentFrame = null;
	
	GeneralConfig myConfig;
	GUIUtils guiUtils;
	ShowData allShows;
	EpisodeData epData;
	TitleFilter editFilter, workFilter;
	HalProgressMonitor pMonitor;
	HelpWindow helpWindow;
	/**
	 * Simple constructor.  Nothing to see here.  Move along.
	 * @param programConfig general program config
	 */
	public TitleFilterControl(GeneralConfig programConfig) {
		int x;
		myConfig = programConfig;
		allShows = (ShowData) myConfig.getObject("allshows");
		epData = new EpisodeData(myConfig, allShows);
		GUISetup();
		guiUtils = new GUIUtils(myConfig);
		guiUtils.setParentFrame(jFrame);
		loadShows();
		filterDesc = editFilter.getRuleDescriptions();
		for (x = 0; x < filterDesc.length; x++) {
			jcbRules.addItem(filterDesc[x]);
		}
//Handled with loadShows(), but in this case we do it again to avoid the chicken-and-egg
//question of what should be created first.
		getShow();
//		editFilter = new TitleFilter();
		workFilter = null;
		myConfig.putObject("titlefiltercontrol", this);
		parentFrame = ((OTRDownload) myConfig.getObject("otrcontrol")).jFrame;
		pMonitor = new HalProgressMonitor(jFrame, "Copying Title Settings...");
		helpWindow = new HelpWindow(600, 400, "Help for titles.", "Old Time Radio Show Downloader Title Help");
		helpFile = myConfig.get("OTRDirectory") + File.separator + helpFile;
		helpWindow.setFile(helpFile);
	}
	
	/**
	 * Load in the names of all the shows to the selection list.
	 */
	public void loadShows() {
		int x, iPoint;
		jlShows.removeListSelectionListener(this);
		iPoint = jlShows.getSelectedIndex();
		if (iPoint < 0)
			iPoint = 0;
		String[] tempTitles = allShows.listSortedTitles();
		showNames = new String[tempTitles.length + 1];
		showNames[0] = "<html><font color=\"red\">Default Tags</font></html>";
		for (x = 0; x < tempTitles.length; x++) {
			showNames[x + 1] = tempTitles[x];
		}
		jlShows.setListData(showNames);
		jlCopyTitles.setListData(showNames);
		if (iPoint >= tempTitles.length)
			iPoint = tempTitles.length - 1;
		jlShows.setSelectedIndex(iPoint);
		jlShows.addListSelectionListener(this);
		lastEditShow = iPoint;
		getShow();
		return;
	}
	
	/**
	 * Reload the shows and make any other pointer changes needed while we do that.
	 */
	public void reload() {
		loadShows();
		return;
	}
	
	/**
	 * Get the data for the selected show.  This includes getting the fitler data
	 * to go with the show and loading all the episode file names.
	 */
	public void getShow() {
		int iPoint = jlShows.getSelectedIndex();
		String showName = defaultFilterFile;
		if (iPoint != 0) {
			showName = (String) jlShows.getSelectedValue();
		}
		String showDir = getShowFile();
		setFilter(showDir);
		loadEpisodes(showName);
		return;
	}
	
	/**
	 * Load the episode file names that go with the selected title.
	 * @param showTitle show title for episodes to load
	 */
	public void loadEpisodes(String showTitle) {
		String[] epList = new String[0];
		if (showTitle == null)
			showTitle = defaultFilterFile;
		if (!showTitle.equals(defaultFilterFile)) {
			epData.loadEpisodes(showTitle);
			epList = epData.listSortedFiles();
		}
		if (epList.length == 0) {
			epList = new String[]{defaultNoEps};
		}
		this.jlEpisodes.setListData(epList);
		return;
	}
	
	/**
	 * Set the filter to use for editing the rules (not a filter used for any processing).
	 * @param showDir the default directory of the show we're loading rules for
	 */
	public void setFilter(String showDir) {
		editFilter = loadFilter(showDir);
		jcbUnderlines.setSelected(editFilter.fixUnderline);
		jcbCaps.setSelected(editFilter.fixSpaceBeforeCaps);
		jcbExtension.setSelected(editFilter.fixExtension);
		jcbSpaces.setSelected(editFilter.fixWhitespace);
		String[] tempRules = editFilter.getRules();
		jlRules.setListData(tempRules);
		return;
	}
	
	/**
	 * Get a title filter and return it.
	 * @param showDir show directory for the title filters we're loading
	 * @return the TitleFilter object we're loading
	 */
	public TitleFilter loadFilter(String showDir) {
		String sDir = myConfig.get("OTRDirectory");
		String fileName = sDir + File.separator + showDir + ".ttl";
		TitleFilter tempFilter = new TitleFilter(fileName);
		return tempFilter;
	}	
	
	/**
	 * Get the default show file name for the currently selected show.
	 * @return file name
	 */
	private String getShowFile() {
		String showFile = "";
		if (jlShows.getSelectedIndex() == 0) {
			showFile = defaultFilterFile;
		} else {
			showFile = (String) jlShows.getSelectedValue();
			showFile = allShows.getDirectory(showFile);
		}
		return showFile;
	}
	
	/**
	 * Get the path for the title file.
	 * @return path for the file for the specified show
	 */
	public String getFilePath(String showTitle) {
		String fullPath = "";
		if (showTitle == null)
			showTitle = defaultFilterFile;
		fullPath = myConfig.get("OTRDirectory") + File.separator + showTitle + ".ttl";
		return fullPath;
	}
		
	/**
	 * Save the filter info to a file.
	 */
	public void saveFilters() {
		editFilter.saveFilter();
		guiUtils.setParentFrame(jFrame);
		guiUtils.showInfoDialog("Title filter rule data saved.");
	}
	
	/**
	 * Add a rule to the list of filter rules and update the display.  If it
	 * needs specific text, then ask for it.
	 */
	public void addRule() {
		String newRule = (String) jcbRules.getSelectedItem();
		boolean needsText = editFilter.ruleNeedsText(newRule);
		if (needsText) {
			String specificPhrase = "";
			guiUtils.setParentFrame(jFrame);
			specificPhrase = guiUtils.showTextDialog("Enter the text you want to\nsearch for in the filter rule:");
			if (specificPhrase == null || specificPhrase.equals(""))
				return;
			newRule = newRule + ":" + specificPhrase;
		}
		editFilter.addRule(newRule);
		refreshRules();
		return;
	}
	
	/**
	 * Delete a filter rule from the rule queue.
	 */
	public void deleteRule() {
		int iPoint = jlRules.getSelectedIndex();
		if (iPoint < 0) return;
		editFilter.deleteRule(iPoint);
		refreshRules();
		return;
	}
	
	/**
	 * Move a rule up or down.  Use a negative number to move it up, a positive one to move it down.
	 * @param iDisplace the distance to move the rule.
	 */
	public void moveRule(int iDisplace) {
		int iPoint = jlRules.getSelectedIndex(), iLong = editFilter.getRuleSize();
		if (iDisplace < 0 && iPoint > 0) {
			editFilter.moveRuleUp(iPoint);
			iPoint--;
		} else if (iDisplace > 0 && iPoint < iLong - 1){
			editFilter.moveRuleDown(iPoint);
			iPoint++;
		}
		jlRules.setSelectedIndex(iPoint);
		refreshRules();
		return;
	}
	
	/**
	 * Refresh the rules JList and set the selected item to what it was.
	 */
	public void refreshRules() {
		int iPoint = jlRules.getSelectedIndex(), iLong;
		String[] newRules = editFilter.getRules();
		jlRules.setListData(newRules);
		iLong = newRules.length;
		if (iLong > 0) {
			if (iPoint > iLong - 1)
				iPoint = iLong - 1;
			jlRules.setSelectedIndex(iPoint);
		}
		return;
	}
	
	/**
	 * Update the episode list with titles that follow our current filters and rules
	 * rather than just file names.
	 *
	 */
	public void updateEpisodes() {
		int x;
		String[] allEps = epData.listSortedFiles();
		for (x = 0; x < allEps.length; x++) {
			allEps[x] = editFilter.filterTitle(allEps[x]);
		}
		jlEpisodes.setListData(allEps);
		return;
	}
	
	/**
	 * Reset the episode list to just the file names.
	 */
	public void resetEpisodes() {
		String[] allEps = epData.listSortedFiles();
		jlEpisodes.setListData(allEps);
		return;
	}
	
	/**
	 * Open the window to select where filters are copied to or from.  Don't copy, just open window
	 * and make selection of a show (or shows) possible
	 * @param copyFrom true if we're copying FROM files.
	 */
	private void setupCopy() {
		String fromLabel = "Copy Filters From Another Show...";
		String toLabel = "Copy Filters To Other Show(s)...";
		if (copyFrom) {
			if (jlShows.getSelectedIndex() == 0) {
				guiUtils.setParentFrame(jFrame);
				guiUtils.showInfoDialog("The default filters values are selected.\nThe default settings cannot be copied over.");
				return;
			}
			jlCopyFromTo.setText(fromLabel);
			jlCopyTitles.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			int[] iCheck = jlCopyTitles.getSelectedIndices();
			if (iCheck.length > 1) {
				jlCopyTitles.clearSelection();
			}
		} else {
			jlCopyFromTo.setText(toLabel);
			jlCopyTitles.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		}
		GUIUtils.centerWindowOnWindow(jFrame, jfCopy);
		setActive(false);
		setCopyActive(true);
		this.jfCopy.setVisible(true);
		return;
	}
	
	/**
	 * Copy the filters from one show to another (or to more than one show).  Use info set up by setupCopy().
	 */
	private void copyTitles() {
		new Thread(new Runnable() {
			public void run() {
				useMonitor = false;
				int x;
				int[] iDest;
				String tagSource = defaultFilterFile, sourceFile, destFile;
				setCopyActive(false);
				if (copyFrom && jlShows.getSelectedIndex() > 0) {
					tagSource = (String) jlCopyTitles.getSelectedValue();
					tagSource = allShows.getDirectory(tagSource);
					iDest = jlShows.getSelectedIndices();
					sourceFile = getFilePath(tagSource);
				} else {
//					System.out.println("Getting show files for source and dest.");
					tagSource = getShowFile();
//					System.out.println("\tSource: " + tagSource);
					iDest = jlCopyTitles.getSelectedIndices();
					sourceFile = getFilePath(tagSource);
					File oFile = new File(sourceFile);
					if (!oFile.exists())
						saveFilters();
				}
//				tagSource = allShows.getDirectory(tagSource);
//				System.out.println("\t\tSource: " + tagSource);
//				if (iDest.length > 3) {
//					useMonitor = true;
//					pMonitor.activate();
//					pMonitor.setTaskLength(0, iDest.length);
//				}
				for (x = 0; x < iDest.length; x++) {
					if (iDest[x] != 0) {
						destFile = showNames[iDest[x]];
						destFile = allShows.getDirectory(destFile);
						destFile = getFilePath(destFile);
						System.out.println("Copying file: " + sourceFile + ", To: " + destFile);
						if (sourceFile.equals(destFile)) {
							System.out.println("\tSkipping self-copy");
							continue;
						}
						File oSource = new File(sourceFile);
						if (!oSource.exists()) {
							String defaultFile = getFilePath(defaultFilterFile);
//							HalFile.copy(defaultFile, sourceFile);
							System.out.println("\tForced to use default file: " + defaultFile);
						}
//						System.out.println("Copying file, Source: " + sourceFile + ", Dest: " + destFile);
						HalFile.copy(sourceFile, destFile);
					} else {
						guiUtils.setParentFrame(jfCopy);
						guiUtils.showInfoDialog("The default filters values are selected.\nThe default settings cannot be copied over.");
					}
//					if (useMonitor) {
//						pMonitor.updateProgressBar(x + 1);
//						if (pMonitor.isCancelled)
//							break;
//					}
				}
//				if (useMonitor)
//					pMonitor.deactivate();
				setActive(true);
				jfCopy.setVisible(false);
			}
		}).start();
		return;
	}

	/**
	 * Set all the components in this window and the copy window to active or inactive.
	 * @param isActive true if components are to be useable
	 */
	public void setActive(boolean isActive) {
		jbClose.setEnabled(isActive);
		jbHelp.setEnabled(isActive);
		jbSave.setEnabled(isActive);
		jbCopyFrom.setEnabled(isActive);
		jbCopyTo.setEnabled(isActive);
		jbMoveUp.setEnabled(isActive);
		jbMoveDown.setEnabled(isActive);
		jbDelete.setEnabled(isActive);
		jbCancel.setEnabled(isActive);
		jbUpdateEpisodes.setEnabled(isActive);
		jcbUnderlines.setEnabled(isActive);
		jcbCaps.setEnabled(isActive);
		jcbExtension.setEnabled(isActive);
		jcbSpaces.setEnabled(isActive);
		jcbRules.setEnabled(isActive);
		jlShows.setEnabled(isActive);
		jlEpisodes.setEnabled(isActive);
		jlRules.setEnabled(isActive);
//Components in copy window
		jbAdd.setEnabled(isActive);
		jbCopy.setEnabled(isActive);
		jlCopyTitles.setEnabled(isActive);
		return;
	}
	
	/**
	 * Set just the components in the copy settings window to active or inactive.
	 * @param isActive true if components are t obe useable
	 */
	public void setCopyActive(boolean isActive) {
		jlCopyTitles.setEnabled(isActive);
		jbCopy.setEnabled(isActive);
		jbCancel.setEnabled(isActive);
		return;
	}
	
	/**
	 * Make us visible.  Center over main window if this is the first time we're visible.
	 * @param isVisible true to make visible
	 */
	public void setVisible(boolean isVisible) {
		this.isVisible = isVisible;
		if (firstOpen && parentFrame != null) {
			GUIUtils.centerWindowOnWindow(parentFrame, jFrame);
			firstOpen = false;
		}
		jFrame.setVisible(isVisible);
		return;
	}
	
	/**
	 * Dispatch actions from all the JButtons to the appropriate subroutine.
	 */
	public void actionPerformed(ActionEvent aEvent) {
		Object sourceControl = aEvent.getSource();
		if (sourceControl == jbCopyFrom) {
			System.out.println("Copying from...");
			copyFrom = true;
			this.setupCopy();
		} else if (sourceControl == jbCopyTo) {
			System.out.println("Copying to...");
			copyFrom = false;
			setupCopy();
		} else if (sourceControl == jbUpdateEpisodes) {
			updateEpisodes();
		} else if (sourceControl == jbResetEpisodes) {
			resetEpisodes();
		} else if (sourceControl == jbMoveUp) {
			moveRule(-1);
		} else if (sourceControl == jbMoveDown) {
			moveRule(1);
		} else if (sourceControl == jbDelete) {
			deleteRule();
		} else if (sourceControl == jbAdd) {
			addRule();
		} else if (sourceControl == jbSave) {
			saveFilters();
		} else if (sourceControl == jbHelp) {
			if (firstHelp)
				helpWindow.centerOnWindow(jFrame);
			firstHelp = false;
			helpWindow.setVisible(true);
		} else if (sourceControl == jbClose) {
			setVisible(false);
		} else if (sourceControl == jcbRules) {
//Placeholder.  Don't think we really need do anything here.
//			System.out.println("Selecting a rule.");
		} else if (sourceControl == this.jbCopy) {
			copyTitles();
			return;
		} else if (sourceControl == this.jbCancel) {
			System.out.println("Cancelling copy command");
			jfCopy.setVisible(false);
			setActive(true);
			return;
		}
		return;
	}
	
	/**
	 * Monitor when the state changes on all the check boxes.  When it
	 * does, change the value in the title filters.
	 */
	public void stateChanged(ChangeEvent cEvent) {
		JCheckBox sourceControl = (JCheckBox) cEvent.getSource();
		boolean bState = sourceControl.isSelected();
		if (sourceControl == jcbUnderlines) {
			editFilter.fixUnderline = bState;
		} else if (sourceControl == jcbCaps) {
			editFilter.fixSpaceBeforeCaps = bState;
		} else if (sourceControl == jcbExtension) {
			editFilter.fixExtension = bState;
		} else if (sourceControl == jcbSpaces) {
			editFilter.fixWhitespace = bState;
		}
	return;
	}
	
	/**
	 * Dispatcher (and required for the listener) to make changes when an item in a
	 * JList is selected.
	 */
	public void valueChanged(ListSelectionEvent lsEvent) {
		JList sourceControl = (JList) lsEvent.getSource();
		int iPoint = sourceControl.getSelectedIndex();
		if (sourceControl == jlShows && iPoint != lastEditShow) {
			getShow();
			lastEditShow = iPoint;
		} else if (sourceControl == jlEpisodes) {
//Placeholder -- don't see why we need to even care about this.
//			System.out.println("Changed episode selection. (Needed???)");
		} else if (sourceControl == jlRules) {
//			Placeholder -- don't think we'll need this.
//			System.out.println("Changed rule selection");
		}
		return;
	}
	
	/**
	 * Do the ugly GUI setup stuff that is a pain to have in the constructor
	 *
	 */
	private void GUISetup() {
		getJFrame();
		getJfCopy();
		jbCopyTo.addActionListener(this);
		jbCopyFrom.addActionListener(this);
		jbUpdateEpisodes.addActionListener(this);
		jbResetEpisodes.addActionListener(this);
		jbMoveUp.addActionListener(this);
		jbMoveDown.addActionListener(this);
		jbDelete.addActionListener(this);
		jbAdd.addActionListener(this);
		jbSave.addActionListener(this);
		jbHelp.addActionListener(this);
		jbClose.addActionListener(this);
		jcbUnderlines.addChangeListener(this);
		jcbCaps.addChangeListener(this);
		jcbExtension.addChangeListener(this);
		jcbSpaces.addChangeListener(this);
		jlShows.addListSelectionListener(this);
		jlEpisodes.addListSelectionListener(this);
		jlRules.addListSelectionListener(this);
		jbCopy.addActionListener(this);
		jbCancel.addActionListener(this);
		jlShows.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		jlRules.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		return;
	}
	
//	=============================================================================
//	Beyond here, there be dragons
//	=============================================================================

	/**
	 * This method initializes jFrame	
	 * 	
	 * @return javax.swing.JFrame	
	 */
	private JFrame getJFrame() {
		if (jFrame == null) {
			jFrame = new JFrame();
			jFrame.setSize(new Dimension(862, 430));
			jFrame.setTitle("Old Time Radio Show Downloader Title Filter");
			jFrame.setContentPane(getJContentPane());
		}
		return jFrame;
	}

	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jLabel3 = new JLabel();
			jLabel3.setText("Filtered Show Title Examples:");
			jLabel3.setAlignmentX(Component.CENTER_ALIGNMENT);
			jLabel2 = new JLabel();
			jLabel2.setText("Title Filter Rules (all applied in the order listed)");
			jLabel2.setAlignmentX(Component.CENTER_ALIGNMENT);
			jLabel1 = new JLabel();
			jLabel1.setText("Simple Title Fixes:");
			jLabel1.setAlignmentX(Component.CENTER_ALIGNMENT);
			jLabel = new JLabel();
			jLabel.setText("Pick A Show To Edit The Title Filters:");
			jLabel.setAlignmentX(Component.CENTER_ALIGNMENT);
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(getJpRuleButtons1(), null);
			jContentPane.add(getJpRulesButtons2(), null);
			jContentPane.add(getJpCenter(), null);
			jContentPane.add(getJPanel1(), null);
			jContentPane.add(getJPanel3(), null);
			jContentPane.add(getJPanel6(), null);
			jContentPane.add(getJPanel7(), null);
			jContentPane.add(getJPanel5(), null);
			jContentPane.add(getJPanel8(), null);
			jContentPane.add(getJPanel9(), null);
			jContentPane.add(getJPanel2(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jbClose	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbClose() {
		if (jbClose == null) {
			jbClose = new JButton();
			jbClose.setText("Close");
			jbClose.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jbClose;
	}

	/**
	 * This method initializes jbHelp	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbHelp() {
		if (jbHelp == null) {
			jbHelp = new JButton();
			jbHelp.setText("Help ");
			jbHelp.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jbHelp;
	}

	/**
	 * This method initializes jbSave	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbSave() {
		if (jbSave == null) {
			jbSave = new JButton();
			jbSave.setText("Save Filters");
		}
		return jbSave;
	}

	/**
	 * This method initializes jbCopyTo	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbCopyFrom() {
		if (jbCopyFrom == null) {
			jbCopyFrom = new JButton();
			jbCopyFrom.setText("Copy From Another");
		}
		return jbCopyFrom;
	}

	/**
	 * This method initializes jbCopyFrom	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbCopyTo() {
		if (jbCopyTo == null) {
			jbCopyTo = new JButton();
			jbCopyTo.setText("Copy To Others");
		}
		return jbCopyTo;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJSPShows() {
		if (jspShows == null) {
			jspShows = new JScrollPane();
			jspShows.setViewportView(getJlShows());
		}
		return jspShows;
	}

	/**
	 * This method initializes jlShows	
	 * 	
	 * @return javax.swing.JList	
	 */
	private JList getJlShows() {
		if (jlShows == null) {
			jlShows = new JList();
		}
		return jlShows;
	}

	/**
	 * This method initializes jcbUnderlines	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJcbUnderlines() {
		if (jcbUnderlines == null) {
			jcbUnderlines = new JCheckBox();
			jcbUnderlines.setText("Replace underlines (\"The_Show\" -> \"The Show\")");
			jcbUnderlines.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jcbUnderlines;
	}

	/**
	 * This method initializes jcbCaps	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJcbCaps() {
		if (jcbCaps == null) {
			jcbCaps = new JCheckBox();
			jcbCaps.setText("Spaces between words  (\"TheShow\" -> \"The Show\")");
			jcbCaps.setAlignmentX(Component.RIGHT_ALIGNMENT);
		}
		return jcbCaps;
	}

	/**
	 * This method initializes jcbExtension	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJcbExtension() {
		if (jcbExtension == null) {
			jcbExtension = new JCheckBox();
			jcbExtension.setText("Cut file extension (\"TheShow.mp3\" -> \"TheShow\")");
			jcbExtension.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jcbExtension;
	}

	/**
	 * This method initializes jspRules	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJspRules() {
		if (jspRules == null) {
			jspRules = new JScrollPane();
			jspRules.setViewportView(getJlRules());
		}
		return jspRules;
	}

	/**
	 * This method initializes jlRules	
	 * 	
	 * @return javax.swing.JList	
	 */
	private JList getJlRules() {
		if (jlRules == null) {
			jlRules = new JList();
		}
		return jlRules;
	}

	/**
	 * This method initializes jbMoveUp	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbMoveUp() {
		if (jbMoveUp == null) {
			jbMoveUp = new JButton();
			jbMoveUp.setText("Move up");
			jbMoveUp.setAlignmentX(Component.LEFT_ALIGNMENT);
		}
		return jbMoveUp;
	}

	/**
	 * This method initializes jbMoveDown	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbMoveDown() {
		if (jbMoveDown == null) {
			jbMoveDown = new JButton();
			jbMoveDown.setText("Move Down");
		}
		return jbMoveDown;
	}

	/**
	 * This method initializes jbDelete	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbDelete() {
		if (jbDelete == null) {
			jbDelete = new JButton();
			jbDelete.setText("Delete");
		}
		return jbDelete;
	}

	/**
	 * This method initializes jbUpdateEpisodes	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbUpdateEpisodes() {
		if (jbUpdateEpisodes == null) {
			jbUpdateEpisodes = new JButton();
			jbUpdateEpisodes.setText("Show Filtered Titles");
		}
		return jbUpdateEpisodes;
	}

	/**
	 * This method initializes jcbRules	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJcbRules() {
		if (jcbRules == null) {
			jcbRules = new JComboBox();
		}
		return jcbRules;
	}

	/**
	 * This method initializes jbAdd	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbAdd() {
		if (jbAdd == null) {
			jbAdd = new JButton();
			jbAdd.setText("Add Rule");
		}
		return jbAdd;
	}

	/**
	 * This method initializes jspEpisodes	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJspEpisodes() {
		if (jspEpisodes == null) {
			jspEpisodes = new JScrollPane();
			jspEpisodes.setViewportView(getJlEpisodes());
		}
		return jspEpisodes;
	}

	/**
	 * This method initializes jlEpisodes	
	 * 	
	 * @return javax.swing.JList	
	 */
	private JList getJlEpisodes() {
		if (jlEpisodes == null) {
			jlEpisodes = new JList();
		}
		return jlEpisodes;
	}

	/**
	 * This method initializes jcbSpaces	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJcbSpaces() {
		if (jcbSpaces == null) {
			jcbSpaces = new JCheckBox();
			jcbSpaces.setText("Trim extra spaces (\" The  Show  \" -> \"The Show\")");
			jcbSpaces.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jcbSpaces;
	}

	/**
	 * This method initializes jfCopy	
	 * 	
	 * @return javax.swing.JFrame	
	 */
	private JFrame getJfCopy() {
		if (jfCopy == null) {
			jfCopy = new JFrame();
			jfCopy.setSize(new Dimension(395, 217));
			jfCopy.setTitle("Copy Settings");
			jfCopy.setContentPane(getJContentPane1());
		}
		return jfCopy;
	}

	/**
	 * This method initializes jContentPane1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane1() {
		if (jpCopyContent == null) {
			jlCopyFromTo = new JLabel();
			jlCopyFromTo.setText("Copy Filters From a Show:");
			jpCopyContent = new JPanel();
			jpCopyContent.setLayout(new BoxLayout(getJContentPane1(), BoxLayout.Y_AXIS));
			jpCopyContent.add(jlCopyFromTo, null);
			jpCopyContent.add(getJScrollPane12(), null);
			jpCopyContent.add(getJPanel(), null);
		}
		return jpCopyContent;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane12() {
		if (jspCopy == null) {
			jspCopy = new JScrollPane();
			jspCopy.setViewportView(getJlCopyTitles());
		}
		return jspCopy;
	}

	/**
	 * This method initializes jbCopy	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbCopy() {
		if (jbCopy == null) {
			jbCopy = new JButton();
			jbCopy.setText("Copy");
		}
		return jbCopy;
	}

	/**
	 * This method initializes jbCancel	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbCancel() {
		if (jbCancel == null) {
			jbCancel = new JButton();
			jbCancel.setText("Cancel");
		}
		return jbCancel;
	}

	/**
	 * This method initializes jlCopyTitles	
	 * 	
	 * @return javax.swing.JList	
	 */
	private JList getJlCopyTitles() {
		if (jlCopyTitles == null) {
			jlCopyTitles = new JList();
		}
		return jlCopyTitles;
	}

	/**
	 * This method initializes jbResetTitles	
	 * 	
	 * @return javax.swing.JToggleButton	
	 */
	private JButton getJbResetTitles() {
		if (jbResetEpisodes == null) {
			jbResetEpisodes = new JButton();
			jbResetEpisodes.setText("Show Unfiltered Titles");
		}
		return jbResetEpisodes;
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			jPanel = new JPanel();
			jPanel.setLayout(new BoxLayout(getJPanel(), BoxLayout.X_AXIS));
			jPanel.add(Box.createHorizontalGlue());
			jPanel.add(getJbCopy(), null);
			jPanel.add(Box.createHorizontalGlue());
			jPanel.add(getJbCancel(), null);
			jPanel.add(Box.createHorizontalGlue());
		}
		return jPanel;
	}

	/**
	 * This method initializes jpCopyButtons	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJpCopyButtons() {
		if (jpCopyButtons == null) {
			jpCopyButtons = new JPanel();
			jpCopyButtons.setLayout(new BoxLayout(getJpCopyButtons(), BoxLayout.X_AXIS));
			jpCopyButtons.add(getJbCopyFrom(), null);
			jpCopyButtons.add(Box.createHorizontalGlue());
			jpCopyButtons.add(getJbCopyTo(), null);
		}
		return jpCopyButtons;
	}

	/**
	 * This method initializes jpTitleButtons	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJpTitleButtons() {
		if (jpTitleButtons == null) {
			jpTitleButtons = new JPanel();
			jpTitleButtons.setLayout(new BoxLayout(getJpTitleButtons(), BoxLayout.X_AXIS));
//			jpTitleButtons.add(Box.createHorizontalGlue());
			jpTitleButtons.add(getJbUpdateEpisodes(), null);
			jpTitleButtons.add(Box.createHorizontalGlue());
			jpTitleButtons.add(getJbResetTitles(), null);
//			jpTitleButtons.add(Box.createHorizontalGlue());
		}
		return jpTitleButtons;
	}

	/**
	 * This method initializes jpRuleButtons1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJpRuleButtons1() {
		if (jpRuleButtons1 == null) {
			jpRuleButtons1 = new JPanel();
			jpRuleButtons1.setLayout(new BoxLayout(getJpRuleButtons1(), BoxLayout.X_AXIS));
			jpRuleButtons1.setBounds(new Rectangle(0, 0, 0, 0));
			jpRuleButtons1.add(Box.createHorizontalGlue());
			jpRuleButtons1.add(Box.createHorizontalGlue());
			jpRuleButtons1.add(Box.createHorizontalGlue());
			jpRuleButtons1.add(Box.createHorizontalGlue());
		}
		return jpRuleButtons1;
	}

	/**
	 * This method initializes jpRulesButtons2	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJpRulesButtons2() {
		if (jpRulesButtons2 == null) {
			jpRulesButtons2 = new JPanel();
			jpRulesButtons2.setLayout(new BoxLayout(getJpRulesButtons2(), BoxLayout.X_AXIS));
			jpRulesButtons2.setBounds(new Rectangle(0, 0, 0, 0));
			jpRulesButtons2.add(Box.createHorizontalGlue());
			jpRulesButtons2.add(Box.createHorizontalGlue());
			jpRulesButtons2.add(Box.createHorizontalGlue());
		}
		return jpRulesButtons2;
	}

	/**
	 * This method initializes jpCenter	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJpCenter() {
		if (jpCenter == null) {
			jpCenter = new JPanel();
			jpCenter.setLayout(new BoxLayout(getJpCenter(), BoxLayout.X_AXIS));
			jpCenter.setBounds(new Rectangle(0, 0, 0, 0));
			jpCenter.add(Box.createHorizontalStrut(100));
		}
		return jpCenter;
	}

	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel1() {
		if (jPanel1 == null) {
			jPanel1 = new JPanel();
			jPanel1.setLayout(new GridBagLayout());
			jPanel1.setBounds(new Rectangle(0, 0, 0, 0));
		}
		return jPanel1;
	}

	/**
	 * This method initializes jPanel2	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel2() {
		if (jPanel2 == null) {
			jPanel2 = new JPanel();
			jPanel2.setLayout(new BoxLayout(getJPanel2(), BoxLayout.Y_AXIS));
			jPanel2.setAlignmentX(Component.LEFT_ALIGNMENT);
			jPanel2.setBounds(new Rectangle(432, 192, 385, 157));
			jPanel2.add(jLabel1, null);
			jPanel2.add(getJPanel10(), null);
		}
		return jPanel2;
	}

	/**
	 * This method initializes jPanel3	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel3() {
		if (jPanel3 == null) {
			jPanel3 = new JPanel();
			jPanel3.setLayout(new GridBagLayout());
			jPanel3.setBounds(new Rectangle(0, 0, 0, 0));
		}
		return jPanel3;
	}

	/**
	 * This method initializes jPanel4	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel4() {
		if (jPanel4 == null) {
			jPanel4 = new JPanel();
			jPanel4.setLayout(new BoxLayout(getJPanel4(), BoxLayout.X_AXIS));
//			jPanel4.add(Box.createHorizontalGlue());
			jPanel4.add(getJbMoveUp(), null);
			jPanel4.add(Box.createHorizontalGlue());
			jPanel4.add(getJbMoveDown(), null);
			jPanel4.add(Box.createHorizontalGlue());
			jPanel4.add(getJbDelete(), null);
//			jPanel4.add(Box.createHorizontalGlue());
		}
		return jPanel4;
	}

	/**
	 * This method initializes jPanel5	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel5() {
		if (jPanel5 == null) {
			jPanel5 = new JPanel();
			jPanel5.setLayout(new BoxLayout(getJPanel5(), BoxLayout.Y_AXIS));
			jPanel5.setBounds(new Rectangle(12, 192, 409, 157));
			jPanel5.add(jLabel2, null);
			jPanel5.add(getJspRules(), null);
			jPanel5.add(getJPanel4(), null);
		}
		return jPanel5;
	}

	/**
	 * This method initializes jPanel6	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel6() {
		if (jPanel6 == null) {
			jPanel6 = new JPanel();
			jPanel6.setLayout(new BoxLayout(getJPanel6(), BoxLayout.Y_AXIS));
			jPanel6.setBounds(new Rectangle(12, 12, 409, 169));
			jPanel6.add(jLabel, null);
			jPanel6.add(getJSPShows(), null);
			jPanel6.add(getJpCopyButtons(), null);
		}
		return jPanel6;
	}

	/**
	 * This method initializes jPanel7	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel7() {
		if (jPanel7 == null) {
			jPanel7 = new JPanel();
			jPanel7.setLayout(new BoxLayout(getJPanel7(), BoxLayout.Y_AXIS));
			jPanel7.setBounds(new Rectangle(432, 12, 385, 169));
			jPanel7.add(jLabel3, null);
			jPanel7.add(getJspEpisodes(), null);
			jPanel7.add(getJpTitleButtons(), null);
		}
		return jPanel7;
	}

	/**
	 * This method initializes jPanel8	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel8() {
		if (jPanel8 == null) {
			jPanel8 = new JPanel();
			jPanel8.setLayout(new BoxLayout(getJPanel8(), BoxLayout.X_AXIS));
			jPanel8.setBounds(new Rectangle(12, 360, 409, 25));
			jPanel8.add(getJcbRules(), null);
			jPanel8.add(getJbAdd(), null);
		}
		return jPanel8;
	}

	/**
	 * This method initializes jPanel9	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel9() {
		if (jPanel9 == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 0;
			gridBagConstraints.gridy = 0;
			jPanel9 = new JPanel();
			jPanel9.setLayout(new BoxLayout(getJPanel9(), BoxLayout.X_AXIS));
			jPanel9.setBounds(new Rectangle(432, 360, 385, 25));
			jPanel9.add(getJbSave(), null);
			jPanel9.add(Box.createHorizontalGlue());
			jPanel9.add(getJbHelp(), null);
			jPanel9.add(Box.createHorizontalGlue());
			jPanel9.add(getJbClose(), null);
		}
		return jPanel9;
	}

	/**
	 * This method initializes jPanel10	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel10() {
		if (jPanel10 == null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(4);
			gridLayout.setColumns(1);
			jPanel10 = new JPanel();
			jPanel10.setLayout(gridLayout);
			jPanel10.add(getJcbUnderlines(), null);
			jPanel10.add(getJcbCaps(), null);
			jPanel10.add(getJcbExtension(), null);
			jPanel10.add(getJcbSpaces(), null);
		}
		return jPanel10;
	}

}
