package com.hal.util;
/**
Class  : FileByLine
Author : Hal Vaughan
Company: Threshold Digital, Ltd.
			4221 Wakefield Rd.
			Richmond, VA 23235
			(804)-560-2820
			thresholddigital.com
			hal@thresholddigital


	FileByLine: Read a file line by line.

	BufferedFileByLine: Read a file into a string, then read it line by line.

	setEOF: Set the string to return when EOF is reached in either FileByLine
	methods.

+	setEOL: Set the EOL marker for what to watch for to mark the end of a line.
	Works for Buffered FileByLine only!

	getError: Get the last error code.

*/

import java.io.*;

public class FileByLine {

	private String sErrorFNF = "Error: File not found";
	private String sErrorIOE = "Error: IO Exception";
//	private byte[] bErrorFNF = sErrorFNF.getBytes();
//	private byte[] bErrorIOE = sErrorIOE.getBytes();
//	private String sData = "";
	private FileReader inFile;
	private BufferedReader inBuffer;
//	private FileInputStream fis;
//	private FileWriter fWriter;
//	private FileOutputStream fOut;

	private boolean bBuffFlag;
	private int iPos = 0, iNext = 0;
	private String fblName = "";
	private String fblData = "";
	private String sError = "";
	private String sEOL = "\n";
	private String sEOF = "";

	public FileByLine (String sName) {
		fblName = sName;
		bBuffFlag = true;
		makeFileByLine();
		return;
	}

	public FileByLine (String sName, boolean bFlag) {
		fblName = sName;
		bBuffFlag = bFlag;
		makeFileByLine();
		return;
	}
	
	/**
	 * All this section deals with FileByLine methods.  If bBuffFlag = true,
	 * we load the file into a string and send it out line by line.  (We can also define
	 * the EOL character, which defaults to "/n".)
	 */
	private void makeFileByLine () {
//		int i = 0, iLen = 0;
		iPos = 0;
		iNext = 0;
		char[] cData;
		if (bBuffFlag) {
			iPos = 0;
			iNext = 0;
			File fInfo = new File(fblName);
			cData = new char[(int) fInfo.length()];
			try {inFile = new FileReader(fblName);}
					catch (FileNotFoundException e) {sError = sErrorFNF; return;}
			inBuffer = new BufferedReader(inFile);
			try {inBuffer.read(cData, 0, (int) fInfo.length());}
					catch (IOException e) {sError = sErrorIOE; return;}
			fblClose();
			fblData = new String(cData);
		} else {
			try {
				inFile = new FileReader(fblName);
				inBuffer = new BufferedReader(inFile);
			} catch (IOException e) {sError = sErrorIOE;}
		}
		return;
	}

	public String getLine() {
		boolean flag = false;
		String sLine = "";
		if (bBuffFlag) {
			if (iPos >= fblData.length()) {sError = "EOF"; return sEOF;}
			iNext = fblData.indexOf(sEOL, iPos);
			if (iNext < 0) {
				iNext = fblData.length();
				sLine = fblData.substring(iPos, iNext);
			} else if (iNext == 0) {
				sLine = "";
			} else {
				sLine = fblData.substring(iPos, iNext);
			}
			iPos = iNext + 1;
		} else {
			try {
				while ((sLine = inBuffer.readLine()) != null) {
					flag = true;
					break;
				}
				if (!flag) {
					sLine = sEOF;
					fblClose();
					sError = "EOF";
				}
			} catch (IOException e) {sError = sErrorIOE;}
		}
		return sLine;
	}

	public void setEOF(String sInput) {
		sEOF = sInput;
		return;
	}

	public void setEOL(String sInput) {
		sEOL = sInput;
		return;
	}

	public String getError() {
		return sError;
	}

	private void fblClose() {
		try {
			inBuffer.close();
			inFile.close();
		} catch (IOException e) {sError = sErrorIOE;}
		return;
	}

}
