package com.hal.util;
/**
Class  : TNDate
Author : Hal Vaughan
Company: Threshold Digital, Ltd.
			4221 Wakefield Rd.
			Richmond, VA 23235
			(804)-560-2820
			thresholddigital.com
			hal@thresholddigital


*/

import java.util.GregorianCalendar;

public class HalDate  {

	private boolean bSendDay = false;
	private int iOffset, iSendOffset;
	private String sDate = "", sThen = "", sSend = "", sSendOffset;
	private String[] aMonth = {"January", "February", "March", "April", "May", "June",
			"July", "August", "September", "October", "November", "December"};
	private GregorianCalendar oCal = new GregorianCalendar();

	public static void main(String[] args) {
		boolean bSend = false, bDay = true;
		int x;
		HalDate oDate = new HalDate();
		String sNow = oDate.getDate(), sIn = oDate.getDate(), sOff = oDate.getSendDate();
		System.out.println("Initialized date: "+sNow+", Offset date: "+sIn+", Offset Send Date: "+sOff);
		String[] aIn;
		for (x = 0; x < args.length; x++) {
			if (args[x].toLowerCase().startsWith("--send")) {bSend = true; continue;}
			if (args[x].toLowerCase().startsWith("--date")) {bSend = false; continue;}
			if (args[x].toLowerCase().startsWith("--day")) {bDay = true; continue;}
			if (args[x].toLowerCase().startsWith("--delay")) {bDay = false; continue;}
			if (bSend) {
				if (args[x].indexOf(":") >= 0) {
					aIn = args[x].split(":");
					sIn = aIn[0];
					sOff = aIn[1];
				} else {
					sIn = args[x];
					sOff = "0";
				}
				oDate.setDate(sIn);
				sNow = oDate.getDate();
				System.out.println("Input date: " + oDate.getDate() + ", Calendar date: "+sNow);
				if (bDay) {
					oDate.setSendOffset(sOff);
				} else {
					oDate.setSendOffset(Integer.parseInt(sOff));
				}
				sNow = oDate.getSendDate();
				System.out.println("Calendar date: "+sNow);
			} else {
				if (args[x].indexOf(":") >= 0) {
					aIn = args[x].split(":");
					sIn = aIn[0];
					sOff = aIn[1];
				} else {
					sIn = args[x];
					sOff = "0";
				}
				oDate.setDate(sIn);
				sNow = oDate.getDate();
				System.out.println("Input date: " + oDate.getDate() + ", Calendar date: "+sNow);
				oDate.setOffset(sOff);
				sNow = oDate.getDate();
				System.out.println("Calendar date: "+sNow);
			}
		}
	}

	public HalDate() {
		reset();
		return;
	}

	public void reset() {
		sDate = aMonth[oCal.get(GregorianCalendar.MONTH)] + " " +
				oCal.get(GregorianCalendar.DAY_OF_MONTH) + ", " +
				oCal.get(GregorianCalendar.YEAR);
		sThen = sDate;
		sSend = sDate;
		return;
	}

	public void setDate(String s1) {
		int iYear = 0, iMonth = 0, iDay = 0, y;
		String[] aDate;
		aDate = s1.split(" ");
		iYear = Integer.parseInt(aDate[2]);
		for (y = 0; y < aMonth.length; y++) {
			if (aDate[0].toLowerCase().equals(aMonth[y].toLowerCase())) {
				iMonth = y;
				break;
			}
		}
		if (aDate[1].indexOf(",") >= 0) {
			aDate = aDate[1].split(",");
		} else {
			aDate[0] = aDate[1];
		}
		iDay = Integer.parseInt(aDate[0]);
		oCal = new GregorianCalendar(iYear, iMonth, iDay);
		sDate = aMonth[oCal.get(GregorianCalendar.MONTH)] + " " +
				oCal.get(GregorianCalendar.DAY_OF_MONTH) + ", " +
				oCal.get(GregorianCalendar.YEAR);
		sThen = sDate;
		sSend = sDate;
		return;
	}

	public void setDate(String s1, String s2) {
		setDate(s1);
		setOffset(s2);
		return;
	}

	public void setDate(String s1, int i1) {
		setDate(s1);
		setOffset(i1);
		return;
	}

	public void setOffset(String s1) {
		int i = Integer.parseInt(s1);
		setOffset(i);
		return;
	}

	public void setOffset(int i1) {
		iOffset = i1;
		setOffset();
		return;
	}

	private void setOffset() {
		GregorianCalendar tempCal = oCal;
		tempCal.add(GregorianCalendar.DATE, iOffset);
		sThen = aMonth[tempCal.get(GregorianCalendar.MONTH)] + " " +
				tempCal.get(GregorianCalendar.DAY_OF_MONTH) + ", " +
				tempCal.get(GregorianCalendar.YEAR);
		return;
	}

	public String getDate() {
		return sThen;
	}

	public String getDate(String s1) {
		setDate(s1);
		setOffset();
		return sThen;
	}

	public String getDate(String s1, String s2) {
		setDate(s1);
		setOffset(s2);
		return sThen;
	}

	public String getDate(String s1, int i1) {
		setDate(s1);
		setOffset(i1);
		return sThen;
	}

	public String getNow() {
		return sDate;
	}

	public String getNow(String s1) {
		setDate(s1);
		return sDate;
	}

	public String getSendDate() {
		return sSend;
	}

	public String getSendDate(String s1) {
		setDate(s1);
		setSendOffset();
		return sSend;
	}

	public String getSendDate(String s1, String s2) {
		bSendDay = true;
		sSendOffset = s2;
		setDate(s1);
		setSendOffset();
		return sSend;
	}

	public String getSendDate(String s1, int i1) {
		bSendDay = false;
		iSendOffset = i1;
		setDate(s1);
		setSendOffset();
		return sSend;
	}

	public void setSendOffset(String s1) {
		bSendDay = true;
		sSendOffset = s1;
		setSendOffset();
		return;
	}

	public void setSendOffset(int i1) {
		bSendDay = false;
		iSendOffset = i1;
		setSendOffset();
		return;
	}

	public void setSendOffset() {
		int x, iDOWNow = 0, iDOWSend = 0, iDiff = 0;;
		int[] iDays = {GregorianCalendar.SUNDAY, GregorianCalendar.MONDAY,
				GregorianCalendar.TUESDAY, GregorianCalendar.WEDNESDAY,
				GregorianCalendar.THURSDAY, GregorianCalendar.FRIDAY,
				GregorianCalendar.SATURDAY};
		String[] aWeek = {"Sunday", "Monday", "Tuesday", "Wednesday",
				"Thursday", "Friday", "Saturday"};
		GregorianCalendar tempCal = oCal;
		if (bSendDay) {
			iDOWNow = tempCal.get(GregorianCalendar.DAY_OF_WEEK);
			for (x = 0; x < aWeek.length; x++) {
				if (sSendOffset.toLowerCase().equals(aWeek[x].toLowerCase())) {
					iDOWSend = iDays[x];
					break;
				}
			}
			iDiff = iDOWSend - iDOWNow;
			if (iDiff < 1) {iDiff = 7 + iDiff;}
			tempCal.add(GregorianCalendar.DATE, iDiff);
			sSend = aMonth[tempCal.get(GregorianCalendar.MONTH)] + " " +
					tempCal.get(GregorianCalendar.DAY_OF_MONTH) + ", " +
					tempCal.get(GregorianCalendar.YEAR);
		} else {
			tempCal.add(GregorianCalendar.DATE, iSendOffset);
			sSend = aMonth[tempCal.get(GregorianCalendar.MONTH)] + " " +
					tempCal.get(GregorianCalendar.DAY_OF_MONTH) + ", " +
					tempCal.get(GregorianCalendar.YEAR);
		}
		return;
	}

}
